###### Pais de Destino ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa funo tem apenas o argumentos "grupo". 
# grupo = (geral, grupo1, grupo2, grupo3)

# Pacotes usados
library(data.table)
library(dplyr)
library(tidyr)
library(ggplot2)
library(scales)
library(openxlsx)
library(stringi)
library(forcats) #para a funo fct_reorder()
library(grid)
library(gridExtra)

# L sisdof_produto
sisdof_produto <- fread("SisDOF_Destino_2012_2017.csv",
                        colClasses = c("character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_produto$V1 <- NULL

#  L sisdof_tora
sisdof_tora <- fread("SisDOF-toras_2012_2017.csv",
                     colClasses = c("character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "character", "character",
                                    "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_tora$V1 <- NULL

#### Formatacao dos nomes dos paises ####

# Abre planilha com nomes de municipios do IBGE, obtida com o Gustavo Bediaga. Essa planilha est sem UF e coordenadas
nome.paises <- read.xlsx("paises.xlsx") # obtida no Ibge em https://ww2.ibge.gov.br/home/estatistica/populacao/registrocivil/2013/codigo_paises.shtm

# Renomeia colunas de nome.paises
colnames(nome.paises) <- c("Codigo.numerico", "Nome.Pais", "Codigo.IsoAlpha")

# Todas para maiscula
nome.paises$Pais.Sisdof <- toupper(nome.paises$Nome.Pais)

# Elimina os acentos ortogrficos
nome.paises$Pais.Sisdof <- stri_trans_general(nome.paises$Pais.Sisdof, 
                                                       "Latin-ASCII")

# Troca espaos por "."
nome.paises$Pais.Sisdof <- gsub("\\s+", ".", nome.paises$Pais.Sisdof)

# Deleta "." no final, se houver
# grep("\\.$", nome.paises$Pais.Sisdof)   #Testa se h municpios com "." no final, caso positivo executar o comando abaixo:
nome.paises$Pais.Sisdof <- gsub("\\.$", "", nome.paises$Pais.Sisdof)

# fusiona sisdof_tora e sisdof_produto
sisdof <- rbind(sisdof_produto, sisdof_tora)

# Cria um subset de sisdof com os nomes dos Municipios.Origen de sisdof que no estao em municipios.ibge
x <- subset(sisdof$Pais.Destino,
            !(sisdof$Pais.Destino %in% nome.paises$Pais.Sisdof))

x <- unique(x)

# Lista dos paises com nomes divergentes:
# "HONG.KONG" = China, Hong Kong
#"REPUBLICA.DA.COREIA" = Coria do Sul
# "REINO.UNIDO.DA.GRA.BRETANHA" = Reino Unido
# "SEYCHELLES" = Seichelles
# "GUADALUPE" = Ilha Guadalupe
# "PAISES.BAIXOS" = Holanda
# TAIWAN = Taiwan
# ANTILHAS.HOLANDESAS = Holanda
# BIELORRUSSIA = Bielorssia
# DESCONHECIDO = Desconhecido
# REPUBLICA.ISLAMICA.DO.IRA = Ir
# ILHAS.VIRGENS.(BRITANICAS) = Ilhas Virgens Britnicas
# FRANCAMETROPOLITANA = Frana
# FEDERACAO.RUSSA = Rssia (Federao Russa)
# REPUBLICA.DEMOCRATICA.POPULAR.DA.COREA = Coria do Norte
# REUNIAO = Ilha Reunio
# BOSNIA.E.HERZEGOVINA = Bsnia-Herzegovina
# TRINIDAD.E.TABAGO = Trinidad e Tobago
# QUATAR = Catar
# TIMOR.ORIENTAL = Timor Leste
# TERRITORIOS.AUSTRAIS.FRANCESES = Territrios Franceses do Sul # obtido em http://www.dgpj.mj.pt/sections/estatisticas-da-justica/metainformacao/nomenclaturas-da-justica/iso-3166-1-codigos-para/downloadFile/file/Nomenclatura_de_paises__8212?nocache=1252486619.5

# Altera manualmente os nomes dos Municipios.Origem divergentes em sisdof_tora

sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "HONG.KONG"] <- "CHINA,.HONG.KONG"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "REPUBLICA.DA.COREIA"] <- "COREIA.DO.SUL"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "REINO.UNIDO.DA.GRA.BRETANHA"] <- "REINO.UNIDO"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "SEYCHELLES"] <- "SEICHELLES"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "GUADALUPE"] <- "ILHA.GUADALUPE"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "PAISES.BAIXOS"] <- "HOLANDA"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "TAIWAN"] <- "Taiwan"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "ANTILHAS.HOLANDESAS"] <- "HOLANDA"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "BIELORRUSSIA"] <- "BIELORUSSIA"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "DESCONHECIDO"] <- "Desconhecido"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "REPUBLICA.ISLAMICA.DO.IRA"] <- "IRA"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "ILHAS.VIRGENS.(BRITANICAS)"] <- "ILHAS.VIRGENS.BRITANICAS"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "FRANCAMETROPOLITANA"] <- "Frana"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "FEDERACAO.RUSSA"] <- "RUSSIA.(FEDERACAO.RUSSA)"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "REPUBLICA.DEMOCRATICA.POPULAR.DA.COREA"] <- "COREIA.DO.NORTE"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "REUNIAO"] <- "ILHA.REUNIAO"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "BOSNIA.E.HERZEGOVINA"] <- "BOSNIA-HERZEGOVINA"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "TRINIDAD.E.TABAGO"] <- "TRINIDAD.E.TOBAGO"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "QUATAR"] <- "CATAR"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "TIMOR.ORIENTAL"] <- "TIMOR.LESTE"
sisdof_produto$Pais.Destino[sisdof_produto$Pais.Destino == "TERRITORIOS.AUSTRAIS.FRANCESES"] <- "Territrios Franceses do Sul"


# Apaga variaveis intermediarias
rm(sisdof, x)

#### Funcao para gerar os graficos Brasil x Exterior ####
pais_destino_brasil <- function (grupo) {
    # grupo = (geral, grupo1, grupo2, grupo3)
    
    # geral = todas as espcies 
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Portaria 443)
    # grupo3 = cites
    
    ifelse(!dir.exists(file.path("Figuras", 
                                 "1.2.Produto.Acabado", 
                                 "1.2.8.Pais.Interno.Exterior")),
           dir.create(file.path("Figuras", 
                                "1.2.Produto.Acabado", 
                                "1.2.8.Pais.Interno.Exterior"),
                      recursive = TRUE),
           FALSE)
    
    setwd(file.path("Figuras", 
                    "1.2.Produto.Acabado", 
                    "1.2.8.Pais.Interno.Exterior"))
    
    
    # Funo para passar apenas a primeira letra de uma palavra para maiscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Ttulos do grfico
    titulo.grupo <- capFirst(grupo)
    g.titulo <- "Consumo de Produtos Madeireiros: Brasil x Exterior"   # Primeiro titulo do grafico
    g.sub.titulo <- "Volume relativo movimentado de 2012 a 2017 (%)"
    
    # Dimensoes do grafico
    #largura <- 10.3
    texto <- 21.87
    bola <- 25.5
    
    # Cores do Grafico: Tons azuis 
    cor_segmento <- "salmon"                # cor da linha   
    cor_ponto <- "firebrick4"                   # cor do ponto
    
    if ( grupo == "geral") {
        
        y <- sisdof_produto
        g.sub.titulo.grupo <- "Todas as espcies"
        
    } else if (grupo == "grupo1") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espcies contidas no grupo 1
        y <- sisdof_produto[sisdof_produto$Grupo == "Grupo.1"]                            # subset com as espcies do grupo 1
        g.sub.titulo.grupo <- "25 Espcies mais movimentadas"
        
    } else if (grupo == "grupo2") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espcies contidas no grupo 2
        y <- sisdof_produto[(sisdof_produto$Portaria.443 == "VU" |                        # subset com as espcies da portaria 443 e que nao estao nos grupos 1 ou 3
                         sisdof_produto$Portaria.443 == "EN" |
                         sisdof_produto$Portaria.443 == "CR") &
                        (sisdof_produto$Grupo != "Grupo.1" &
                             sisdof_produto$Grupo != "Grupo.3")]
        g.sub.titulo.grupo <- "Espcies ameaadas de extino"
        
    } else if (grupo == "grupo3") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espcies contidas no grupo 3
        y <- sisdof_produto[(sisdof_produto$Cites == "I" |                                # subset com as espcies da portaria 443 e que nao estao nos grupos 1 ou 3
                         sisdof_produto$Cites == "II" |
                         sisdof_produto$Cites == "III") &
                        (sisdof_produto$Grupo != "Grupo.1" &
                             sisdof_produto$Grupo != "Grupo.2")]
        g.sub.titulo.grupo <- "Espcies CITES"
        
    }
    
    ## Faz o grfico dos grupos
    
    # Agrega de acordo com o Pais de Destino
    agregado <- y[, .(sum(Volume.Total)),
                  by = .(y$Pais.Destino)]
    
    # Ordena de forma crescente em relao ao Volume.Total
    agregado$y[agregado$y == "BRASIL"] <- "Brasil"
    agregado$y[agregado$y != "Brasil"] <- "Exterior"
    
    # Agrega de acordo com o Pais de Destino
    agregado <- agregado[, .(sum(V1)),
                  by = .(agregado$y)]
    
    # Cria a coluna volume percentual
    agregado$Volume.Percentual <- agregado$V1/sum(agregado$V1)*100
    
    # Renomeia as colunas V1 e V2  
    colnames(agregado) <- c("Pais.Destino", "Volume.Total", "Volume.Percentual")
    
    # Ordena pelo Volume.Total
    agregado$Pais.Destino <- factor(agregado$Pais.Destino, 
                                  levels = unique(agregado$Pais.Destino)[order(agregado$Volume.Percentual, 
                                                                             decreasing = TRUE)])
   
    # Largura do grafico. Varia de acordo com o tamanho do titulo ou subtitulo. Como a fonte do titulo e 10% maior do que a do subtitulo, multiplicamos por 1.11.
    
    largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                          valor = c(1.11*nchar(g.titulo), 
                                    nchar(g.sub.titulo.grupo),
                                    nchar(g.sub.titulo)))
    
    largura <- max(largura$valor, na.rm = TRUE)
    
    # Altura do grafico
    altura <- 1.3 + (0.8*length(agregado$Pais.Destino))
    
    if (length(agregado$Pais.Destino) != 0) {
    
    # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
    agregado <- mutate(agregado,  Pais.Destino = fct_reorder(agregado$Pais.Destino,
                                                             agregado$Volume.Percentual))
    
    
    # Gera o grafico percentual do agregado e exterior
    gplot <- ggplot(agregado, aes(agregado$Pais.Destino, 
                                agregado$Volume.Percentual)) +
        geom_segment(aes(x = agregado$Pais.Destino, 
                         y = 0, 
                         xend = agregado$Pais.Destino, 
                         yend = agregado$Volume.Percentual),
                     position = position_dodge(width = 0.1),
                     color = cor_segmento,
                     size = bola/3) +
        geom_point(size = bola,
                   color = cor_ponto,
                   position = position_dodge(width = 0.1))+
        scale_y_continuous(limits=c(0, 1.1*max(agregado$Volume.Percentual)), oob=rescale_none)+
        geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                     big.mark = ".", 
                                     decimal.mark = ",")),
                  color = "white", 
                  size = 0.3*texto,
                  fontface = "bold")+
        theme(plot.title = element_text(lineheight = 0.1, 
                                        face = "bold",
                                        hjust = 0.5,
                                        size = 1.3*texto),
              plot.subtitle = element_text(lineheight = 0.4, 
                                           face = "bold",
                                           hjust = 0.5,
                                           size = 1.17*texto),
              axis.title.y = element_blank(),
              axis.text.y = element_text(size = 1.1*texto,
                                         color = cor_ponto,
                                         face = "bold",
                                         hjust = 0),
              axis.title.x = element_blank(),
              axis.text.x = element_blank(),
              axis.ticks.x = element_blank(),
              axis.ticks.y = element_blank(),
              panel.background = element_blank(),
              panel.grid.major = element_blank(), 
              panel.grid.minor = element_blank())+
        coord_flip()
        
    # Abre para gravacao em PDF
    pdf(paste0("#", 
               titulo.grupo, 
               "_Interno_Exterior.pdf"), 
        width = largura/5, 
        height = altura)
    
    grid.arrange(
        gplot,
        nrow = 1,
        top = textGrob(paste0(g.titulo,
                              "\n",
                              g.sub.titulo.grupo,
                              "\n",
                              g.sub.titulo),
                       gp = gpar(fontface = 2, 
                                 fontsize = 26,
                                 lineheight = 0.8)))
    
    
    # Fecha o PDF
    dev.off()
    
    }
    
    ## Faz os grficos para cada uma das espcies da lista dos grupos 1, 2 ou 3.
    
    if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        for (i in 1:length(lista_especies)) {
            
            especie <- y[y$Especie == lista_especies[i]]
            
            # Agrega de acordo com o municipio de origem e UF.Origem
            especie <- especie[, .(sum(Volume.Total)),
                               by = .(especie$Pais.Destino)]
            
            # Ordena de forma crescente em relao ao Volume.Total
            especie$especie[especie$especie == "BRASIL"] <- "Brasil"
            especie$especie[especie$especie != "Brasil"] <- "Exterior"
            
            # Agrega de acordo com o Pais de Destino
            especie <- especie[, .(sum(V1)),
                                 by = .(especie)]
            
            # Cria a coluna volume percentual
            especie$Volume.Percentual <- especie$V1/sum(especie$V1)*100
            
            # Renomeia as colunas V1 e V2  
            colnames(especie) <- c("Pais.Destino", "Volume.Total", "Volume.Percentual")
            
            # Para o grafico entender que  pra ordenar pelo Volume.Total
            especie$Pais.Destino <- factor(especie$Pais.Destino, 
                                          levels = unique(especie$Pais.Destino)[order(especie$Volume.Percentual, 
                                                                                     decreasing = TRUE)])
            
            # Ordena de forma crescente em relao ao Volume.Total
            especie <- especie[order(especie$Volume.Percentual, 
                                           decreasing = TRUE),]
            
            # Largura do grafico.
            largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                                  valor = c(1.11*nchar(g.titulo), 
                                            nchar(lista_especies[i]),
                                            nchar(g.sub.titulo)))
            
            largura <- max(largura$valor, na.rm = TRUE)
            
            # Altura do grafico
            altura <- 1.3 + (0.8*length(especie$Pais.Destino))
            
            if (length(especie$Pais.Destino) != 0) {
            
            # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
            especie <- mutate(especie,  Pais.Destino = fct_reorder(especie$Pais.Destino,
                                                                   especie$Volume.Percentual))
            
            
            gplot <- ggplot(especie, 
                            aes(especie$Pais.Destino,
                                especie$Volume.Percentual))+
                geom_segment(aes(x = especie$Pais.Destino, 
                                 y = 0, 
                                 xend = especie$Pais.Destino, 
                                 yend = especie$Volume.Percentual),
                             position = position_dodge(width = 0.1),
                             color = cor_segmento,
                             size = bola/3) +
                geom_point(size = bola,
                           color = cor_ponto,
                           position = position_dodge(width = 0.1))+
                scale_y_continuous(limits=c(0, 1.1*max(especie$Volume.Percentual)), oob=rescale_none)+
                geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                             big.mark = ".", 
                                             decimal.mark = ",")),
                          color = "white", 
                          size = 0.3*texto,
                          fontface = "bold")+
                theme(plot.title = element_text(lineheight = 0.1, 
                                                face = "bold",
                                                hjust = 0.5,
                                                size = 1.3*texto),
                      plot.subtitle = element_text(lineheight = 0.4, 
                                                   face = "bold",
                                                   hjust = 0.5,
                                                   size = 1.17*texto),
                      axis.title.y = element_blank(),
                      axis.text.y = element_text(size = 1.1*texto,
                                                 color = cor_ponto,
                                                 face = "bold",
                                                 hjust = 0),
                      axis.title.x = element_blank(),
                      axis.text.x = element_blank(),
                      axis.ticks.x = element_blank(),
                      axis.ticks.y = element_blank(),
                      panel.background = element_blank(),
                      panel.grid.major = element_blank(), 
                      panel.grid.minor = element_blank())+
                coord_flip()
            
            # Abre para gravacao em PDF
            pdf(paste0(titulo.grupo,
                       "_", 
                       lista_especies[i],
                       "_Interno_Exterior.pdf"), 
                width = largura/5, 
                height = altura)
            
            grid.arrange(
                gplot,
                nrow = 1,
                top = textGrob(paste0(g.titulo,
                                      "\n",
                                      lista_especies[i],
                                      "\n",
                                      g.sub.titulo),
                               gp = gpar(fontface = 2, 
                                         fontsize = 26,
                                         lineheight = 0.8)))
            
            
            # Fecha o PDF
            dev.off()
            
            }
            
        }
        
    }
    
    setwd("..")
    setwd("..")
    setwd("..")
    
}    

pais_destino_brasil("geral")
pais_destino_brasil("grupo1")
pais_destino_brasil("grupo2")
pais_destino_brasil("grupo3")


#### Funcao para gerar graficos dos paises estrangeiros de destino ####
pais_destino_exterior <- function (grupo) {
    # grupo = (geral, grupo1, grupo2, grupo3)
    
    # geral = todas as espcies 
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Portaria 443)
    # grupo3 = cites
    
    ifelse(!dir.exists(file.path("Figuras", 
                                 "1.2.Produto.Acabado", 
                                 "1.2.9.Pais.Destino.Exterior")),
           dir.create(file.path("Figuras", 
                                "1.2.Produto.Acabado", 
                                "1.2.9.Pais.Destino.Exterior"),
                      recursive = TRUE),
           FALSE)
    
    setwd(file.path("Figuras", 
                    "1.2.Produto.Acabado", 
                    "1.2.9.Pais.Destino.Exterior"))
    
    
    # Funo para passar apenas a primeira letra de uma palavra para maiscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Ttulos do grfico
    titulo.grupo <- capFirst(grupo)
    g.titulo <- "Pases Estrageiros Consumidores de Produtos Madeireiros"   # Primeiro titulo do grafico
    g.sub.titulo <- "Volume relativo movimentado de 2012 a 2017 (%)"
    
    # Dimensoes do grafico
    #largura <- 10.3
    texto <- 21.87
    bola <- 25.5
    
    # Cores do Grafico: Tons vermelhos 
    cor_segmento <- "salmon"                # cor da linha   
    cor_ponto <- "firebrick4"                   # cor do ponto
    
    if ( grupo == "geral") {
        
        y <- sisdof_produto
        g.sub.titulo.grupo <- "Todas as espcies"
        
    } else if (grupo == "grupo1") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espcies contidas no grupo 1
        y <- sisdof_produto[sisdof_produto$Grupo == "Grupo.1"]                            # subset com as espcies do grupo 1
        g.sub.titulo.grupo <- "25 Espcies mais movimentadas"
        
    } else if (grupo == "grupo2") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espcies contidas no grupo 2
        y <- sisdof_produto[(sisdof_produto$Portaria.443 == "VU" |                        # subset com as espcies da portaria 443 e que nao estao nos grupos 1 ou 3
                                 sisdof_produto$Portaria.443 == "EN" |
                                 sisdof_produto$Portaria.443 == "CR") &
                                (sisdof_produto$Grupo != "Grupo.1" &
                                     sisdof_produto$Grupo != "Grupo.3")]
        g.sub.titulo.grupo <- "Espcies ameaadas de extino"
        
    } else if (grupo == "grupo3") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espcies contidas no grupo 3
        y <- sisdof_produto[(sisdof_produto$Cites == "I" |                                # subset com as espcies da portaria 443 e que nao estao nos grupos 1 ou 3
                                 sisdof_produto$Cites == "II" |
                                 sisdof_produto$Cites == "III") &
                                (sisdof_produto$Grupo != "Grupo.1" &
                                     sisdof_produto$Grupo != "Grupo.2")]
        g.sub.titulo.grupo <- "Espcies CITES"
        
    }
    
    ## Faz o grfico dos grupos
    
    # Cria o subset que contm todos os pases de destino, exceto o Brasil.
    agregado <- y[y$Pais.Destino != "BRASIL"]
    
    # Agrega de acordo com o Pais de Destino
    agregado <- agregado[, .(sum(Volume.Total)),
                  by = .(agregado$Pais.Destino)]
    
    # Cria a coluna volume percentual
    agregado$Volume.Percentual <- agregado$V1/sum(agregado$V1)*100
    
    # Renomeia as colunas V1 e V2  
    colnames(agregado) <- c("Pais.Destino", "Volume.Total", "Volume.Percentual")
    
    # Ordena pelo Volume.Total
    agregado$Pais.Destino <- factor(agregado$Pais.Destino, 
                                    levels = unique(agregado$Pais.Destino)[order(agregado$Volume.Percentual, 
                                                                                 decreasing = TRUE)])
    
    # Ordena de forma crescente em relao ao Volume.Total
    agregado <- agregado[order(agregado$Volume.Percentual, decreasing = TRUE),]
    
    # Parametros do grafico
    
    if (length(unique(agregado$Pais.Destino)) >= 10) {
        
        agregado <- agregado[1:10,]
        
        } else {
        
        agregado <- agregado[1:length(unique(agregado$Pais.Destino)),]
        
        }
    
    # modifica os nomes dos municipios a serem mostrados no grafico
    
    x <- match(agregado$Pais.Destino, 
               nome.paises$Pais.Sisdof)   # procura os nomes dos paises de agregado$Pais.Destino que esto presentes em nome.paises$Pais.Sisdof. O resultado  o objeto x no qual iro aparecer as posies em nome.paises$Pais.Sisdof que possuem nomes de paises de agregado$Pais.Destino 
    #x <- x[!is.na(x)]                               # esse comando elimina de x os NAs. Dessa forma, x contm as posies em nomes.diferentes$Especie.Sisflora das especies de sisdof1$Especies com nomes escritos de forma errada e que devem ser substituido pelos nomes contidos em nomes.diferentes$Especie.Resolvida
    
    agregado$Pais.Destino2 <-  nome.paises$Nome.Pais[x]  # 
    
    agregado$Pais.Destino2[is.na(agregado$Pais.Destino2)] <- as.character(agregado$Pais.Destino[is.na(agregado$Pais.Destino2)])
    
    agregado$Pais.Destino <- agregado$Pais.Destino2
    
    agregado$Pais.Destino2 <- NULL
    
    # Largura do grafico. Varia de acordo com o tamanho do titulo ou subtitulo. Como a fonte do titulo e 10% maior do que a do subtitulo, multiplicamos por 1.11.
    
    largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                          valor = c(1.11*nchar(g.titulo), 
                                    nchar(g.sub.titulo.grupo),
                                    nchar(g.sub.titulo)))
    
    largura <- max(largura$valor, na.rm = TRUE)
    
    # Altura do grafico
    altura <- 1.3 + (0.8*length(agregado$Pais.Destino))
    
    if (!is.na(agregado$Pais.Destino)) {
        
    # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
    agregado <- mutate(agregado,  Pais.Destino = fct_reorder(agregado$Pais.Destino,
                                                             agregado$Volume.Percentual))
    
    
    # Gera o grafico percentual do agregado e exterior
    gplot <- ggplot(agregado, aes(agregado$Pais.Destino, 
                                  agregado$Volume.Percentual)) +
        geom_segment(aes(x = agregado$Pais.Destino, 
                         y = 0, 
                         xend = agregado$Pais.Destino, 
                         yend = agregado$Volume.Percentual), 
                     position = position_dodge(width = 0.8),
                     color = cor_segmento,
                     size = bola/3) +
        geom_point(size = bola,
                   color = cor_ponto,
                   position = position_dodge(width = 0.8))+
        scale_y_continuous(limits=c(0, 1.1*max(agregado$Volume.Percentual)), oob=rescale_none)+
        geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                     big.mark = ".", 
                                     decimal.mark = ",")),
                  color = "white", 
                  size = 0.3*texto,
                  fontface = "bold")+
       theme(plot.title = element_text(lineheight = 0.1, 
                                        face = "bold",
                                        hjust = 0.5,
                                        size = 1.3*texto),
              plot.subtitle = element_text(lineheight = 0.4, 
                                           face = "bold",
                                           hjust = 0.5,
                                           size = 1.17*texto),
              axis.title.y = element_blank(),
              axis.text.y = element_text(size = 1.1*texto,
                                         color = cor_ponto,
                                         face = "bold",
                                         hjust = 0),
              axis.title.x = element_blank(),
              axis.text.x = element_blank(),
              axis.ticks.x = element_blank(),
              axis.ticks.y = element_blank(),
              panel.background = element_blank(),
              panel.grid.major = element_blank(), 
              panel.grid.minor = element_blank())+
        coord_flip()
    
    # Abre para gravacao em PDF
    pdf(paste0("#", 
               titulo.grupo, 
               "_Pais_Destino_Exterior.pdf"), 
        width = largura/5, 
        height = altura)
    
    grid.arrange(
        gplot,
        nrow = 1,
        top = textGrob(paste0(g.titulo,
                              "\n",
                              g.sub.titulo.grupo,
                              "\n",
                              g.sub.titulo),
                       gp = gpar(fontface = 2, 
                                 fontsize = 26,
                                 lineheight = 0.8)))
   
    # Fecha o PDF
    dev.off()
    
    }
    
    ## Faz os grficos para cada uma das espcies da lista dos grupos 1, 2 ou 3.
    
    if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        for (i in 1:length(lista_especies)) {
            especie <- y[y$Especie == lista_especies[i]]
            
            # Cria o subset que contm todos os pases de destino, exceto o Brasil.
            especie <- especie[especie$Pais.Destino != "BRASIL"]
            
            # Agrega de acordo com o Pais de Destino
            especie <- especie[, .(sum(Volume.Total)),
                                 by = .(especie$Pais.Destino)]
            
            # Cria a coluna volume percentual
            especie$Volume.Percentual <- especie$V1/sum(especie$V1)*100
            
            # Renomeia as colunas V1 e V2  
            colnames(especie) <- c("Pais.Destino", "Volume.Total", "Volume.Percentual")
            
            # Para o grafico entender que  pra ordenar pelo Volume.Total
            especie$Pais.Destino <- factor(especie$Pais.Destino, 
                                              levels = unique(especie$Pais.Destino)[order(especie$Volume.Percentual, 
                                                                                             decreasing = TRUE)])
            
            # Ordena de forma crescente em relao ao Volume.Total
            especie <- especie[order(especie$Volume.Percentual, 
                                           decreasing = TRUE),]
            
            
            # Parametros do grafico
            
            if (length(unique(especie$Pais.Destino)) >= 10) {
                
                especie <- especie[1:10,]
                
                } else {
                
                especie <- especie[1:length(unique(especie$Pais.Destino)),]
                
                }
            
            # modifica os nomes dos municipios a serem mostrados no grafico
            
            x <- match(especie$Pais.Destino, 
                       nome.paises$Pais.Sisdof)   # procura os nomes dos paises de especie$Pais.Destino que esto presentes em nome.paises$Pais.Sisdof. O resultado  o objeto x no qual iro aparecer as posies em nome.paises$Pais.Sisdof que possuem nomes de paises de especie$Pais.Destino 
            #x <- x[!is.na(x)]                               # esse comando elimina de x os NAs. Dessa forma, x contm as posies em nomes.diferentes$Especie.Sisflora das especies de sisdof1$Especies com nomes escritos de forma errada e que devem ser substituido pelos nomes contidos em nomes.diferentes$Especie.Resolvida
            
            especie$Pais.Destino2 <-  nome.paises$Nome.Pais[x]  # 
            
            especie$Pais.Destino2[is.na(especie$Pais.Destino2)] <- as.character(especie$Pais.Destino[is.na(especie$Pais.Destino2)])
            
            especie$Pais.Destino <- especie$Pais.Destino2
            
            especie$Pais.Destino2 <- NULL
            
            # Largura do grafico.
            largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                                  valor = c(1.11*nchar(g.titulo), 
                                            nchar(lista_especies[i]),
                                            nchar(g.sub.titulo)))
            
            largura <- max(largura$valor, na.rm = TRUE)
            
            # Altura do grafico
            altura <- 1.3 + (0.8*length(especie$Pais.Destino))
            
            if (!is.na(especie$Pais.Destino)) {
                
                # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
                especie <- mutate(especie,  Pais.Destino = fct_reorder(especie$Pais.Destino,
                                                                       especie$Volume.Percentual))
            
            
            gplot <- ggplot(especie, 
                            aes(especie$Pais.Destino,
                                especie$Volume.Percentual))+
                geom_segment(aes(x = especie$Pais.Destino, 
                                 y = 0, 
                                 xend = especie$Pais.Destino, 
                                 yend = especie$Volume.Percentual), 
                             position = position_dodge(width = 0.8),
                             color = cor_segmento,
                             size = bola/3) +
                geom_point(size = bola,
                           color = cor_ponto,
                           position = position_dodge(width = 0.8))+
                scale_y_continuous(limits=c(0, 1.1*max(especie$Volume.Percentual)), oob=rescale_none)+
                geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                             big.mark = ".", 
                                             decimal.mark = ",")),
                          color = "white", 
                          size = 0.3*texto,
                          fontface = "bold")+
                theme(plot.title = element_text(lineheight = 0.1, 
                                                face = "bold",
                                                hjust = 0.5,
                                                size = 1.3*texto),
                      plot.subtitle = element_text(lineheight = 0.4, 
                                                   face = "bold",
                                                   hjust = 0.5,
                                                   size = 1.17*texto),
                      axis.title.y = element_blank(),
                      axis.text.y = element_text(size = 1.1*texto,
                                                 color = cor_ponto,
                                                 face = "bold",
                                                 hjust = 0),
                      axis.title.x = element_blank(),
                      axis.text.x = element_blank(),
                      axis.ticks.x = element_blank(),
                      axis.ticks.y = element_blank(),
                      panel.background = element_blank(),
                      panel.grid.major = element_blank(), 
                      panel.grid.minor = element_blank())+
                coord_flip()
            
            # Abre para gravacao em PDF
            pdf(paste0(titulo.grupo,
                       "_", 
                       lista_especies[i],
                       "_Pais_Destino_Exterior.pdf"), 
                width = largura/5, 
                height = altura)
            
            grid.arrange(
                gplot,
                nrow = 1,
                top = textGrob(paste0(g.titulo,
                                      "\n",
                                      lista_especies[i],
                                      "\n",
                                      g.sub.titulo),
                               gp = gpar(fontface = 2, 
                                         fontsize = 26,
                                         lineheight = 0.8)))
            
            # Fecha o PDF
            dev.off()
            
            }
            
        }
        
    }
    
    setwd("..")
    setwd("..")
    setwd("..")
    
}    

pais_destino_exterior("geral")
pais_destino_exterior("grupo1")
pais_destino_exterior("grupo2")
pais_destino_exterior("grupo3")



    
    
    
    

   
    
    